/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.genetic;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.genetic.AgriAllele;
import com.agricraft.agricraft.api.genetic.AgriGene;
import com.agricraft.agricraft.api.genetic.AgriGeneMutator;
import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.genetic.AgriMutationHandler;
import com.agricraft.agricraft.api.plant.AgriPlant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class GeneSpecies
implements AgriGene<String> {
    public static final String ID = "species";
    public static final Map<String, StringAllele> alleles = new HashMap<String, StringAllele>();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public AgriAllele<String> defaultAllele(AgriPlant object) {
        String id = AgriApi.getPlantId(object).map(class_2960::toString).orElse("");
        StringAllele allele = alleles.get(id);
        if (allele != null) {
            return allele;
        }
        allele = new StringAllele(id, this);
        alleles.put(id, allele);
        return allele;
    }

    @Override
    public AgriAllele<String> getAllele(String value) {
        StringAllele allele = alleles.get(value);
        if (allele != null) {
            return allele;
        }
        allele = new StringAllele(value, this);
        alleles.put(value, allele);
        return allele;
    }

    @Override
    public AgriGeneMutator<String> mutator() {
        return AgriMutationHandler.getInstance().getActivePlantMutator();
    }

    @Override
    public void writeToNBT(class_2487 genes, AgriAllele<String> dominant, AgriAllele<String> recessive) {
        class_2487 species = new class_2487();
        species.method_10582("dom", dominant.trait());
        species.method_10582("rec", recessive.trait());
        genes.method_10566(ID, (class_2520)species);
    }

    @Override
    public AgriGenePair<String> readFromNBT(class_2487 genes) {
        class_2487 species = genes.method_10562(ID);
        return new AgriGenePair<String>(this, this.getAllele(species.method_10558("dom")), this.getAllele(species.method_10558("rec")));
    }

    @Override
    public void addTooltip(List<class_2561> tooltipComponents, String trait) {
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"agricraft.gene.species").method_27693(": " + trait).method_27692(class_124.field_1063));
    }

    @Override
    public int getDominantColor() {
        return -4259713;
    }

    @Override
    public int getRecessiveColor() {
        return -8453953;
    }

    public static class StringAllele
    implements AgriAllele<String> {
        private final String trait;
        private final AgriGene<String> gene;

        public StringAllele(String trait, AgriGene<String> gene) {
            this.trait = trait;
            this.gene = gene;
        }

        @Override
        public String trait() {
            return this.trait;
        }

        @Override
        public boolean isDominant(AgriAllele<String> other) {
            int b;
            if (this.equals(other)) {
                return true;
            }
            int a = AgriApi.getMutationHandler().complexity(this.trait());
            if (a == (b = AgriApi.getMutationHandler().complexity(other.trait()))) {
                return this.trait().compareTo(other.trait()) < 0;
            }
            return a > b;
        }

        @Override
        public AgriGene<String> gene() {
            return this.gene;
        }
    }
}

